/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.pa.event;

import com.ibm.hwmca.fw.pa.ProblemAnalysisRoutine;
import com.ibm.hwmca.fw.pa.config.AnalysisDomainData;
import com.ibm.hwmca.fw.pa.config.AnalysisEventData;
import com.ibm.hwmca.fw.pa.config.AnalysisRoutineData;
import com.ibm.hwmca.fw.pa.config.ConsoleADData;
import com.ibm.hwmca.fw.pa.config.EventManagerData;
import com.ibm.hwmca.fw.pa.event.EventPersistence;
import com.ibm.hwmca.fw.pa.event.PersistableProblemAnalysisEvent;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEvent;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventListener;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.domain.AnalysisDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class ProblemAnalysisEventManager {
    private static final String TRACE_MASKT = "XPAFAEMT";
    private static final String TRACE_MASKF = "XPAFAEMF";
    private static final String TRACE_MASKD = "XPAFAEMD";
    private static final Class PROBLEM_ANALYSIS_EVENT_CLASS = class$com$ibm$hwmca$fw$pa$event$ProblemAnalysisEvent == null ? (class$com$ibm$hwmca$fw$pa$event$ProblemAnalysisEvent = ProblemAnalysisEventManager.class$("com.ibm.hwmca.fw.pa.event.ProblemAnalysisEvent")) : class$com$ibm$hwmca$fw$pa$event$ProblemAnalysisEvent;
    protected String name = null;
    private Map configData = null;
    private EventPersistence eventPersistence = null;
    private List listeners = new ArrayList();
    private Object listenersLock = new Object();
    static /* synthetic */ Class class$com$ibm$hwmca$fw$pa$event$ProblemAnalysisEvent;

    public ProblemAnalysisEventManager(EventManagerData emData, EventPersistence eventPersistence) {
        Trace.trace(TRACE_MASKD, "--> ctor");
        this.eventPersistence = eventPersistence;
        this.name = emData.getName();
        this.configData = emData.getConfigurationData().getConfigurationData();
        Map adMap = emData.getAnalysisDomainMap();
        if (adMap != null && !adMap.isEmpty()) {
            Iterator adIter = adMap.values().iterator();
            AnalysisDomainData adData = null;
            String clsName = null;
            Class<?> cls = null;
            Object clsInstance = null;
            while (adIter.hasNext()) {
                adData = (AnalysisDomainData)adIter.next();
                if (!(adData instanceof ConsoleADData)) continue;
                Trace.trace(TRACE_MASKD, "Processing Analysis Domain '" + adData.getName() + "'.");
                clsName = adData.getClassName();
                try {
                    cls = Class.forName(clsName);
                    clsInstance = cls.newInstance();
                    ((AnalysisDomain)clsInstance).buildDomainInstances(adData, this);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKT, "Exception constructing domain instances.  Ignoring domain.");
                    Trace.trace(TRACE_MASKT, e);
                }
            }
            adIter = ProblemAnalysisEventManager.sortedInterator(adMap.values());
            while (adIter.hasNext()) {
                adData = (AnalysisDomainData)adIter.next();
                if (adData instanceof ConsoleADData) continue;
                Trace.trace(TRACE_MASKD, "Processing Analysis Domain '" + adData.getName() + "'.");
                clsName = adData.getClassName();
                try {
                    cls = Class.forName(clsName);
                    clsInstance = cls.newInstance();
                    ((AnalysisDomain)clsInstance).buildDomainInstances(adData, this);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKT, "Exception constructing domain instances.  Ignoring domain.");
                    Trace.trace(TRACE_MASKT, e);
                }
            }
        }
        Trace.trace(TRACE_MASKD, "Processing Analysis Events and Routines.");
        Map analysisEvents = emData.getAnalysisEventsData().getAnalysisEvents();
        Map analysisRoutines = emData.getAnalysisRoutinesData().getAnalysisRoutines();
        Iterator iterator = analysisRoutines.keySet().iterator();
        while (iterator.hasNext()) {
            AnalysisRoutineData arData = (AnalysisRoutineData)analysisRoutines.get(iterator.next());
            InnerListener innerListener = new InnerListener(arData.getClassName());
            Iterator eventIterator = arData.getEventNames().iterator();
            while (eventIterator.hasNext()) {
                String eventName = (String)eventIterator.next();
                AnalysisEventData aeData = (AnalysisEventData)analysisEvents.get(eventName);
                if (aeData != null) {
                    String eventClass = aeData.getClassName();
                    try {
                        innerListener.addClass(Class.forName(eventClass));
                        Trace.trace(TRACE_MASKD, "AnalysisRoutine " + arData.getClassName() + " listens for event " + aeData.getClassName());
                    }
                    catch (ClassNotFoundException e) {
                        Trace.trace(TRACE_MASKT, "Warning: ClassNotFoundException (" + eventClass + ") while attempting to load class for event '" + eventName + "', ignoring.");
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKT, "Warning: Exception (" + e.getMessage() + ") while attempting to load class for event '" + eventName + "', ignoring.");
                    }
                    continue;
                }
                Trace.trace(TRACE_MASKT, "Warning: Unable to find specified event '" + eventName + "' in mapping, ignoring.");
            }
            if (!arData.isLazy()) {
                innerListener.createListenerInstance();
            }
            this.listeners.add(innerListener);
        }
        Trace.trace(TRACE_MASKD, "<-- ctor");
    }

    public Map getConfigData() {
        return this.configData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(ProblemAnalysisEvent event) {
        if (event instanceof PersistableProblemAnalysisEvent) {
            this.eventPersistence.storeEvent(event);
        }
        Object object = this.listenersLock;
        synchronized (object) {
            ArrayList daList = (ArrayList)((ArrayList)this.listeners).clone();
            Iterator iterator = daList.iterator();
            while (iterator.hasNext()) {
                try {
                    ((InnerListener)iterator.next()).fireEvent(event);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKT, "Warning: Exception (" + e.getMessage() + ") while calling event handler, ignoring handler.");
                    Trace.trace(TRACE_MASKT, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ProblemAnalysisEventListener listener, Class eventClass) {
        Object object = this.listenersLock;
        synchronized (object) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                InnerListener thisInnerList = (InnerListener)iterator.next();
                if (thisInnerList != listener) continue;
                thisInnerList.addClass(eventClass);
                return;
            }
            InnerListener newListener = new InnerListener(listener);
            newListener.addClass(eventClass);
            this.listeners.add(newListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ProblemAnalysisEventListener listener, Class eventClass) {
        Object object = this.listenersLock;
        synchronized (object) {
            InnerListener target = null;
            Iterator iterator = this.listeners.iterator();
            while (target == null && iterator.hasNext()) {
                InnerListener thisInnerList = (InnerListener)iterator.next();
                if (thisInnerList != listener) continue;
                target = thisInnerList;
            }
            if (target != null) {
                target.removeClass(eventClass);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ProblemAnalysisEventListener listener) {
        Object object = this.listenersLock;
        synchronized (object) {
            InnerListener target = null;
            Iterator iterator = this.listeners.iterator();
            while (target == null && iterator.hasNext()) {
                InnerListener thisInnerList = (InnerListener)iterator.next();
                if (thisInnerList != listener) continue;
                target = thisInnerList;
            }
            if (target != null) {
                this.listeners.remove(target);
            }
        }
    }

    static Iterator sortedInterator(Collection collection) {
        ArrayList<AnalysisDomainData> list = new ArrayList<AnalysisDomainData>();
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            AnalysisDomainData element = (AnalysisDomainData)it.next();
            String theName = element.getClassName();
            Trace.trace(TRACE_MASKD, "the name is: " + theName);
            if (theName.equals("com.ibm.hsc.ccfw.pa.domain.PowerAnalysisDomain")) {
                Trace.trace(TRACE_MASKD, "got a power domain it's first");
                list.add(0, element);
                continue;
            }
            Trace.trace(TRACE_MASKD, "got other type. add to end.");
            list.add(element);
        }
        Trace.trace(TRACE_MASKD, "the sorted list is " + list.size());
        Iterator newIt = list.iterator();
        while (newIt.hasNext()) {
            Trace.trace(TRACE_MASKD, "name is" + ((AnalysisDomainData)newIt.next()).getClassName());
        }
        return list.iterator();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class InnerListener {
        ArrayList classes = new ArrayList();
        ProblemAnalysisEventListener listener = null;
        String className = null;

        InnerListener(String className) {
            this.className = className;
        }

        InnerListener(ProblemAnalysisEventListener listener) {
            this.listener = listener;
        }

        void createListenerInstance() {
            if (this.listener == null) {
                try {
                    Trace.trace(ProblemAnalysisEventManager.TRACE_MASKD, "Attempting creation of analysis routine (" + this.className + ")");
                    this.listener = (ProblemAnalysisEventListener)Class.forName(this.className).newInstance();
                    if (this.listener instanceof ProblemAnalysisRoutine) {
                        ((ProblemAnalysisRoutine)((Object)this.listener)).setEventManager(ProblemAnalysisEventManager.this);
                    }
                }
                catch (ClassNotFoundException e) {
                    Trace.trace(ProblemAnalysisEventManager.TRACE_MASKT, "Warning: ClassNotFoundException creating analysis routine '" + this.className + "', ignoring.");
                }
                catch (SecurityException e) {
                    Trace.trace(ProblemAnalysisEventManager.TRACE_MASKT, "Warning: SecurityException creating analysis routine '" + this.className + "', ignoring.");
                }
                catch (InstantiationException e) {
                    Trace.trace(ProblemAnalysisEventManager.TRACE_MASKT, "Warning: InstantiationException creating analysis routine '" + this.className + "', ignoring.");
                }
                catch (IllegalAccessException e) {
                    Trace.trace(ProblemAnalysisEventManager.TRACE_MASKT, "Warning: IllegalAccessException creating analysis routine '" + this.className + "', ignoring.");
                }
                catch (ClassCastException e) {
                    Trace.trace(ProblemAnalysisEventManager.TRACE_MASKT, "Warning: ClassCastException creating analysis routine '" + this.className + "', ignoring.");
                }
                catch (Exception e) {
                    Trace.trace(ProblemAnalysisEventManager.TRACE_MASKT, "Warning: Exception (" + e.getMessage() + ") creating analysis routine '" + this.className + "', ignoring.");
                }
            }
        }

        ProblemAnalysisEventListener getListener() {
            return this.listener;
        }

        void addClass(Class aClass) {
            if (!PROBLEM_ANALYSIS_EVENT_CLASS.isAssignableFrom(aClass)) {
                throw new IllegalArgumentException("Event class not subclass of ProblemAnalysisEvent");
            }
            if (!this.classes.contains(aClass)) {
                this.classes.add(aClass);
            }
        }

        void removeClass(Class aClass) {
            if (!PROBLEM_ANALYSIS_EVENT_CLASS.isAssignableFrom(aClass)) {
                throw new IllegalArgumentException("Event class not subclass of ProblemAnalysisEvent");
            }
            this.classes.remove(aClass);
        }

        void fireEvent(ProblemAnalysisEvent event) {
            Trace.trace(ProblemAnalysisEventManager.TRACE_MASKD, "AnalysisRoutine event proxy " + this.className + " considers event " + event.getClass());
            ArrayList daList = (ArrayList)this.classes.clone();
            Iterator iterator = daList.iterator();
            Class<?> candidate = event.getClass();
            while (iterator.hasNext()) {
                if (!((Class)iterator.next()).isAssignableFrom(candidate)) continue;
                if (this.listener == null) {
                    this.createListenerInstance();
                    if (this.listener == null) {
                        Trace.trace(ProblemAnalysisEventManager.TRACE_MASKT, "Warning: Unable to create analysis routine " + this.className + ", unable to route event.");
                        return;
                    }
                }
                Trace.trace(ProblemAnalysisEventManager.TRACE_MASKD, "AnalysisRoutine event proxy " + this.className + " calls analyze() for event " + event.getClass());
                this.listener.analyze(event);
                return;
            }
        }
    }
}

